/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.client;

import codechicken.lib.render.shader.CCShaderInstance;
import codechicken.lib.render.shader.CCUniform;
import codechicken.lib.util.ClientUtils;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import morph.avaritia.client.AvaritiaTextures;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class AvaritiaShaders {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");
    private static final float[] COSMIC_UVS = new float[40];
    public static final RenderType COSMIC_RENDER_TYPE = RenderType.m_173215_((String)"avaritia:cosmic", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> cosmicShader)).m_110663_(RenderStateShard.f_110112_).m_110671_(RenderStateShard.f_110152_).m_110685_(RenderStateShard.f_110139_).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.f_110145_).m_110691_(true));
    public static CCShaderInstance cosmicShader;
    public static CCUniform cosmicTime;
    public static CCUniform cosmicYaw;
    public static CCUniform cosmicPitch;
    public static CCUniform cosmicExternalScale;
    public static CCUniform cosmicOpacity;
    public static CCUniform cosmicUVs;

    public static void init() {
        LOCK.lock();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(AvaritiaShaders::onRegisterShaders);
        MinecraftForge.EVENT_BUS.addListener(AvaritiaShaders::onRenderTick);
    }

    private static void onRegisterShaders(RegisterShadersEvent event) {
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceManager(), (ResourceLocation)new ResourceLocation("avaritia", "cosmic"), (VertexFormat)DefaultVertexFormat.f_85811_), e -> {
            cosmicShader = (CCShaderInstance)e;
            cosmicTime = Objects.requireNonNull(cosmicShader.getUniform("time"));
            cosmicYaw = Objects.requireNonNull(cosmicShader.getUniform("yaw"));
            cosmicPitch = Objects.requireNonNull(cosmicShader.getUniform("pitch"));
            cosmicExternalScale = Objects.requireNonNull(cosmicShader.getUniform("externalScale"));
            cosmicOpacity = Objects.requireNonNull(cosmicShader.getUniform("opacity"));
            cosmicUVs = Objects.requireNonNull(cosmicShader.getUniform("cosmicuvs"));
            cosmicShader.onApply(() -> cosmicTime.glUniform1f((float)ClientUtils.getRenderTime()));
        });
    }

    private static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        for (int i = 0; i < AvaritiaTextures.COSMIC_SPRITES.length; ++i) {
            TextureAtlasSprite sprite = AvaritiaTextures.COSMIC_SPRITES[i];
            AvaritiaShaders.COSMIC_UVS[i * 4 + 0] = sprite.m_118409_();
            AvaritiaShaders.COSMIC_UVS[i * 4 + 1] = sprite.m_118411_();
            AvaritiaShaders.COSMIC_UVS[i * 4 + 2] = sprite.m_118410_();
            AvaritiaShaders.COSMIC_UVS[i * 4 + 3] = sprite.m_118412_();
        }
        if (cosmicUVs != null) {
            cosmicUVs.glUniformF(false, COSMIC_UVS);
        }
    }
}

